#version 330
#extension GL_EXT_gpu_shader4 : enable
//myfluidMod01.fsh  by   vortex
//https://www.shadertoy.com/view/MljSzW
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed   //*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// Created by Stefan Draganov - vortex/2015
// License Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License.

#define TILE 1

const float s= 8.0;

vec3 n(vec2 x,float t)
{
    vec3 v=floor(vec3(x,t));
#if TILE==1
    vec3 u=vec3(mod(v.xy,s),v.z);//this should make it tile across the edges :)
#else
    vec3 u=v;
#endif
    vec3 c=fract(
        u.xyz*(vec3(0.16462,0.84787,0.98273)+
         u.xyz*vec3(0.24808,0.75905,0.13898)+
         u.yzx*vec3(0.31517,0.62703,0.26063)+
         u.zxy*vec3(0.47127,0.58568,0.37244))+
        
        u.yzx*(vec3(0.35425,0.65187,0.12423)+
         u.yzx*vec3(0.95238,0.93187,0.95213)+
         u.zxy*vec3(0.31526,0.62512,0.71837))+
        
        u.zxy*(vec3(0.95213,0.13841,0.16479)+
         u.zxy*vec3(0.47626,0.69257,0.19738))
    );//*vec3(0.5,0.5,1.0)+vec3(0.25,0.25,0.0);//*vec3(1.0,1.0,0.5)+vec3(0.0,0.0,0.25);
    
    return v+c;
}

vec3 col(vec2 x,float t)
{
    return vec3(0.5)+0.5*cos(fract(vec3(x,t))*371.0241);
}

vec2 idx(vec2 x)
{
    return 
        //clamp(floor(3.0*normalize(vec2(x.y,-x.x))),vec2(-1.0),vec2(1.0));
                       floor(fract(x*29.0)*3.0)-vec2(1.0);
}

float circle(vec2 x,vec2 c,float r)
{
    return max(0.0,1.0-dot(x-c,x-c)/(r*r));//<r*r?1.0:0.0;
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
	vec2 x = s*(gl_FragCoord.xy-1.0*iMouse.xy)/iResolution.xy;
    
    float t=iTime*0.1;
    
    vec4 c=vec4(vec3(0.0),0.1);
    
    for (int N=0;   N<3; N++)
    for (int k=-1; k<=0; k++)
    for (int i=-1; i<=1; i++)
    for (int j=-1; j<=1; j++)
    {
        vec2  X=x+vec2(j,i);
        float t=t+float(N)*38.0;
        float T=t+float(k);
        vec3 a=n(X,T);
        
        vec2 o=idx(a.xy);
        vec3 b=
            //a+vec3(o,1.0);
          n(X+o,T+1.0);//*/
        vec2 m=mix(a.xy,b.xy,(t-a.z)/(b.z-a.z));
        
        float r=0.4*sin(3.1415927*clamp((t-a.z)/(b.z-a.z),0.0,1.0));
        
        if (length(a.xy-b.xy)/(b.z-a.z)>2.0) r=0.0;
        
        c+=vec4(col(a.xy,a.z),
                1.0)*circle(x,m,r);
    }
    //c+=dot(x,x)<5.0*5.0?vec3(1.0,0.0,0.0):vec3(0.0);
	gl_FragColor = vec4(c.rgb/max(1e-5,c.w)+vec3(0.0,0.0,0.5),1.0);
}